/*
 * Decompiled with CFR 0.152.
 */
package net.yggdraszil.edexpandere.block.mechanicalsieves;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.network.PacketDistributor;
import net.yggdraszil.edexpandere.block.ModBlockEntities;
import net.yggdraszil.edexpandere.config.ExpandereConfig;
import net.yggdraszil.edexpandere.menu.mechanicalsieves.CreativeMechanicalSieveMenu;
import net.yggdraszil.edexpandere.networking.ModMessages;
import net.yggdraszil.edexpandere.networking.packet.SieveDataSyncPacket;
import thedarkcolour.exdeorum.blockentity.AbstractMachineBlockEntity;
import thedarkcolour.exdeorum.blockentity.helper.EnergyHelper;
import thedarkcolour.exdeorum.blockentity.helper.ItemHelper;
import thedarkcolour.exdeorum.blockentity.logic.SieveLogic;
import thedarkcolour.exdeorum.recipe.RecipeUtil;
import thedarkcolour.exdeorum.tag.EItemTags;

public class CreativeMechanicalSieveBlockEntity
extends AbstractMachineBlockEntity<CreativeMechanicalSieveBlockEntity>
implements SieveLogic.Owner {
    private static final Component TITLE = Component.m_237115_((String)"edexpandere.container.creative_mechanical_sieve");
    private static final int INPUT_SLOT = 0;
    public static final int MESH_SLOT = 1;
    private final SieveLogic logic = new SieveLogic((SieveLogic.Owner)this, true);
    private final EnergyHelper energyHelper = new EnergyHelper(ExpandereConfig.creative_mechanical_sieve_energyStorage);

    public CreativeMechanicalSieveBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.CREATIVE_MECHANICAL_SIEVE.get(), pos, state, ItemHandler::new, ExpandereConfig.creative_mechanical_sieve_energyStorage);
    }

    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        this.logic.saveNbt(nbt);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.logic.loadNbt(nbt);
    }

    protected boolean isRunning() {
        return !this.logic.getContents().m_41619_();
    }

    protected void tryStartRunning() {
        ItemStack input = this.inventory.getStackInSlot(0);
        if (this.logic.isValidInput(input)) {
            this.logic.startSifting(input.m_41777_());
            input.m_41774_(1);
        }
        if (this.f_58857_ != null && !this.f_58857_.f_46443_ && this.f_58857_.m_46467_() % 5L == 0L) {
            ModMessages.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new SieveDataSyncPacket(this.energy.getEnergyStored(), this.logic.getProgress(), this.f_58858_));
        }
    }

    protected void runMachineTick() {
        this.logic.sift((float)ExpandereConfig.creative_mechanical_sieve_speed, Long.MAX_VALUE);
    }

    protected int getEnergyConsumption() {
        return ExpandereConfig.creative_mechanical_sieve_energyConsumption;
    }

    public void writeVisualData(FriendlyByteBuf buffer) {
        buffer.m_130055_(this.logic.getMesh());
        buffer.writeFloat(this.logic.getProgress());
        buffer.m_130055_(this.logic.getContents());
    }

    public void readVisualData(FriendlyByteBuf buffer) {
        this.logic.setMesh(buffer.m_130267_(), false);
        this.logic.setProgress(buffer.readFloat());
        this.logic.setContents(buffer.m_130267_());
    }

    public EnergyHelper getEnergyHelper() {
        return this.energyHelper;
    }

    public boolean handleResultItem(ItemStack result, ServerLevel level, RandomSource rand) {
        ItemStack remainder = result.m_41777_();
        for (int i = 2; i < 22; ++i) {
            boolean splitRemainder;
            ItemStack existing = this.inventory.getStackInSlot(i);
            int limit = this.inventory.getSlotLimit(i);
            if (!existing.m_41619_()) {
                if (!ItemHandlerHelper.canItemStacksStack((ItemStack)remainder, (ItemStack)existing)) continue;
                limit -= existing.m_41613_();
            }
            if (limit <= 0) continue;
            boolean bl = splitRemainder = remainder.m_41613_() > limit;
            if (existing.m_41619_()) {
                this.inventory.setStackInSlot(i, splitRemainder ? ItemHandlerHelper.copyStackWithSize((ItemStack)remainder, (int)limit) : remainder);
            } else {
                existing.m_41769_(splitRemainder ? limit : remainder.m_41613_());
            }
            if (!splitRemainder) {
                return true;
            }
            remainder = ItemHandlerHelper.copyStackWithSize((ItemStack)remainder, (int)(remainder.m_41613_() - limit));
        }
        return remainder.m_41613_() < result.m_41613_();
    }

    public Component m_5446_() {
        return TITLE;
    }

    public AbstractContainerMenu m_7208_(int containerId, Inventory playerInventory, Player pPlayer) {
        return new CreativeMechanicalSieveMenu(containerId, playerInventory, this);
    }

    public SieveLogic getLogic() {
        return this.logic;
    }

    public ServerLevel getServerLevel() {
        return (ServerLevel)this.f_58857_;
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.inventory.getSlots());
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            inventory.m_6836_(i, this.inventory.getStackInSlot(i));
        }
        assert (this.f_58857_ != null);
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
    }

    private static class ItemHandler
    extends ItemHelper {
        private final CreativeMechanicalSieveBlockEntity sieve;

        public ItemHandler(CreativeMechanicalSieveBlockEntity sieve) {
            super(22);
            this.sieve = sieve;
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            if (slot == 0) {
                return !RecipeUtil.getSieveRecipes((Item)this.getStackInSlot(1).m_41720_(), (ItemStack)stack).isEmpty();
            }
            return slot == 1 ? stack.m_204117_(EItemTags.SIEVE_MESHES) : false;
        }

        public int getSlotLimit(int slot) {
            return slot == 1 ? 1 : super.getSlotLimit(slot);
        }

        public boolean canMachineExtract(int slot) {
            return slot > 1;
        }

        protected void onContentsChanged(int slot) {
            if (slot == 1) {
                this.sieve.logic.setMesh(this.sieve.inventory.getStackInSlot(1));
            }
        }

        protected void onLoad() {
            this.sieve.logic.setMesh(this.sieve.inventory.getStackInSlot(1), false);
        }
    }
}

